/*    
 Copyright 2013 Adobe Systems Incorporated.  All rights reserved. 
    Purpose- This file contains all the Constants that are used in LiveEditing Feature
*/
/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*jshint -W100 */

var DW_EXTENSION_EVENT = {
    HIDE_AUX_HUD: "hide_aux_hud",
    TOGGLE_AUX_HUD: "toggleAuxHud",
    AUX_HUD_HIDDEN: "auxHudHidden",
    AUX_HUD_ESCAPED: "auxHudEscaped",
    ELEMENT_DIMENSION_CHANGED: "elementDimensionChanged",
    SELECTION_CHANGE: "dw_selection_changed",
    STYLES_RELOADED: "liveview_styles_reloaded",
    INSPECT_ON: "liveview_inspect_on",
    TEXT_EDIT_BEGIN: "text editing started",
    TEXT_EDIT_END: "text editing ended",
	TEXTEDIT_SELECTION_CHANGED: "Selection changed inside textedit",
    TEXTEDIT_SELECTION_LOST: "Selection lost inside textedit",
    SHOW_AUX_HUD: "show_aux_hud",
    RELOAD_ESH: "reload_esh",
    FILE_SAVE: "file_save",
    FILE_SAVE_AS: "file_save_as",
    VIEW_LOST_FOCUS: "liveview_lostfocus"
};

var DW_LIVEEDIT_CONSTANTS = {
    GlobalContainerDiv: "dw-container-div",
    ContainerDiv: "dw-div",
    ImageHudContainerId: "dw_liveedit_img_hud",
    ElementHudContainerId: "dw_liveedit_es_hud",
    TextEditContainerId: "dw_liveedit_text_hud",
    OverlayDivId: "dw_liveedit_overlay_div",
    TextFormattingHudId: "dw_liveedit_text_hud_container",
    ERContainerId: "dw_liveedit_editable_rgn",
    TextContainer: "DW_SPAN",
	NonBreakingSpace: "&nbsp;",
	MarkupForLessThan: "&lt;",
	MarkupForGreatorThan: "&gt;",
    HudEditableSelectors: "Editable Selectors",
    HudTextEdit: "Text Edit",
    HudImageHud: "Image Hud",
    HudText: "Text Formatting Hud",
    HudEditableRegion: "Editable Regions",
    Extensions: "Extensions",
    //this string should match with LiveEditUtils.h:LIVE_EDIT_EXTENSIONS_RESOURCE_PATH_PLACEHOLDER
    ExtensionsResourcePathPlaceHolder: "dwExtensionsResourcePath",
    EditableRegionBeginText: " InstanceBeginEditable ",
    EditableRegionEndText: " InstanceEndEditable",
    OverlayBorderWidth: 1,
    none: "none",
    undef: "undefined",
    DWUniqueId: "data_liveedit_tagid",
    DWTempId: "data_temp_dwid",
    DWSpanId: "DW_SPAN_ID",
    FontStyleId : "FONT_STYLE_ID",
    FontWeightId : "FONT_WEIGHT_ID",
	AttrbuteID:	"id",
    EnterKeyCode: 13,
	BackSpace: 8,
	DeleteKey: 46,
    OverlayCSS_TextEdit: "overlay_textEdit",
    OverlayCSS_TextEdit_disabledUI: "overlay_textEdit_disabledUI",
    DisableSelectionOnBody_TextEdit : "disable_selection",
    TabKeyCode: 9,
    SpaceKeyCode: 32,
    EscapeKeyCode: 27,
	NBSPCharCode: 160,
    HTMLTagName: "HTML",
    TableDataTagName: "TD",
	TableHeaderTagName: "TH",
    ImgTagName: "img",
    AltTagName: "alt",
    InputTagName: "INPUT",
    TextAreaTagName: "TEXTAREA",
    LabelTagName: "LABEL",
    ForAttribute: "for",
    OverlayPadding_Left: 2,
    OverlayPadding_Right: 4,
    OverlayPadding_Top: 0,
    OverlayPadding_Bottom: 0,
    ThresholdForDoubleClick: 400,
    textEditedInLiveView: "textEditLiveView",
    textEditEventCategory: "endAction",
    filter: "*.png|*.gif|*.jpg|*.jpeg|*.psd",
	ParentNotMatching: "Parent not Matching",
	RedrawTimeOut: 20,
    DwImageHud: "dwImageHud"
    
};

var DW_LIVEEDIT_EVENTS = {

    SetElement: "SetElement",
    Destroy: "Destroy",
    Commit: "Commit",
    PreCommit : "Before Committing",
    Draw: "Draw",
    Escape: "Escape",
    POSTEscape: "POSTEscape",
    ImageHudStateChange: "Sandwich Icon Clicked",
    DoubleClick: "Double Click",
    SingleClick: "Single Click",
    ElementChanged: "ElementChanged", //Trigger this event if any edit operation change display rect of any element.
    EditOpFailed: "EditOpFailed", //Trigger this event when anything like edit operation is canceled and want to ER HUD back.
    EditingText: "EditingText", //Trigger this event to hide all the ER HUDs.
    SaveDocument: "Save Document",
	EnterTextEdit : "EnterTextEdit",
    TextEditSelectionChange: "Selection Changed inside TextEditing",
    TextEditSelectionLost: " Selection is lost inside TextEditing",
    ViewLostFocus: "View Lost Focus" //Live view has lost focus
};

//
// Constant values for text editing.
//
var DW_LIVE_TEXT_EDIT = {
    QuatationChar: 34,
    ApostropheChar: 39,
    AmpersandChar: 38,
    LessThanChar: 60,
    GreaterThanChar: 62,
    EntityCodeStart: 161, // ISO 8859-1 Symbols begining code
    Triple_Click_Position_Threshold: 10,
    Triple_Click_Interval_Threshold: 350,
    Triple_Click_Selection_Threshold: 10
};

var DW_LIBRARY_ITEM = {
    Begin: " #BeginLibraryItem ",
    End: " #EndLibraryItem "
};

DW_LIVE_TEXT_EDIT.TagsWhereRunsMaySwap = [
	"UL",
	"OL"
];

DW_LIVE_TEXT_EDIT.WhiteSpaceChars = [
    9, // Tab
    10, // New Line (LF)
    32 // Blank Space
];

DW_LIVE_TEXT_EDIT.TagsNeedsRedraw = [
	"LI",
	"TD",
    "TH",
    "TR"
];

DW_LIVE_TEXT_EDIT.BlockInclusionList = [
    "P",
    "H1",
	"H2",
	"H3",
	"H4",
	"H5",
	"H6",
	"LI",
	"LEGEND",
	"ADDRESS",
	"LABEL"
];

//
// Below tags creates nested p tags as their childs when enter is pressed.
//
// TODO: All the below tags have been removed from BlockInclusionList.
//  So it should be empty array. But leaving this tags wouldn't make any
//  effect in enter key handling. Have to clean up later.
DW_LIVE_TEXT_EDIT.TagsThatCreatesPTagsOnEnter = [
	"BODY",
	"DIV",
	"HEADER",
	"HGROUP",
	"ASIDE",
	"ARTICLE",
	"SECTION",
	"FOOTER",
	"NAV",
	"TR",
    "MAIN"
];

DW_LIVE_TEXT_EDIT.LeaveEnterKeyPressBehaviourToBrowser = [
	"LABEL"
];

DW_LIVE_TEXT_EDIT.InlineTextElements = [
    "STRONG",
    "EM",
    "BR",
    "TIME",
    "B",
    "BIG",
    "I",
    "SMALL",
    "TT",
    "ABBR",
    "ACRONYM",
    "CITE",
    "CODE",
    "DFN",
    "KBD",
    "SAMP",
    "VAR",
    "A",
    "BDO",
    "Q",
    "SPAN",
    "SUB",
    "SUP",
    "FONT",
    "U",
	"INS",
	"DEL",
	"STRIKE",
    "IMG",
	"WBR",
	"S",
	"MARK",
	"BDI",
	"BLACKFACE"
    // Following tags are not included in grouping
    //"BUTTON",
    //"INPUT",
    //"LABEL",
    //"SELECT",
    //"TEXTAREA",
    //"OBJECT",
    //"MAP",
    //"SCRIPT",
];

DW_LIVE_TEXT_EDIT.DynamicTags = [
    "<?php",
    "<%",
    "<cf"
];

DW_LIVE_TEXT_EDIT.DynamicTypes = [
    "php",
    "jsp",
    "cfm",
    "php_mysql",
    "asp"
];

//
// List of actions that we do after browser handles enter key press.
//
var ENTER_POST_PROCESSING_ACTIONS = {
	ChangeCurrentNodeContentToNBSP:                0,
	ChangePreviousSiblingContentToNBSP:            1,
	ChangeCurrentNodeToParaAndChangeContentToNBSP: 2,
	CreateNestedPTagsAndInsertThemToOrignalParent: 3
};

DW_LIVE_TEXT_EDIT.Entities = {
    "&quot;" : 34,
    "&apos;" : 39,
    "&pound;" : 163,
    "&yen;"  : 165,
    "&sect;" : 167,
    "&uml;"  : 168,
    "&iexcl;" : 161,
    "&cent;" : 162,
    "&copy;" : 169,
    "&laquo;" : 171,
    "&not;"  : 172,
    "&reg;"  : 174,
    "&deg;"  : 176,
    "&plusmn;" : 177,
    "&acute;" : 180,
    "&micro;" : 181,
    "&para;" : 182,
    "&middot;" : 183,
    "&cedil;": 184,
    "&raquo;": 187,
    "&iquest;": 191,
    "&Agrave;": 192,
    "&Aacute;": 193,
    "&Acirc;": 194,
    "&Atilde;": 195,
    "&Auml;": 196,
    "&Aring;": 197,
    "&AElig;": 198,
    "&Ccedil;": 199,
    "&Egrave;": 200,
    "&Eacute;": 201,
    "&Ecirc;": 202,
    "&Euml;" : 203,
    "&Igrave;" : 204,
    "&Iacute;" : 205,
    "&Icirc;" : 206,
    "&Iuml;" : 207,
    "&Ntilde;" : 209,
    "&Ograve;" : 210,
    "&Oacute;" : 211,
    "&Ocirc;" : 212,
    "&Otilde;" : 213,
    "&Ouml;" : 214,
    "&Oslash;" : 216,
    "&Ugrave;" : 217,
    "&Uacute;" : 218,
    "&Ucirc;" : 219,
    "&Uuml;" : 220,
    "&szlig;" : 223,
    "&agrave;" : 224,
    "&aacute;" : 225,
    "&acirc;" : 226,
    "&atilde;" : 227,
    "&auml;" : 228,
    "&aring;" : 229,
    "&aelig;" : 230,
    "&ccedil;" : 231,
    "&egrave;" : 232,
    "&eacute;" : 233,
    "&ecirc;" : 234,
    "&euml;" : 235,
    "&igrave;" : 236,
    "&iacute;" : 237,
    "&icirc;" : 238,
    "&iuml;" : 239,
    "&ntilde;" : 241,
    "&ograve;" : 242,
    "&oacute;" : 243,
    "&ocirc;" : 244,
    "&otilde;" : 245,
    "&ouml;" : 246,
    "&divide;" : 247,
    "&oslash;" : 248,
    "&ugrave;" : 249,
    "&uacute;" : 250,
    "&ucirc;" : 251,
    "&uuml;" : 252,
    "&yuml;" : 255,
    "&curren;" : 164,
    "&brvbar;" : 166,
    "&ordf;" : 170,
    "&shy;"  : 173,
    "&macr;" : 175,
    "&sup1;" : 185,
    "&sup2;" : 178,
    "&sup3;" : 179,
    "&ordm;" : 186,
    "&frac14;" : 188,
    "&frac12;" : 189,
    "&frac34;" : 190,
    "&times;" : 215,
    "&ETH;"  : 208,
    "&Yacute;" : 221,
    "&THORN;" : 222,
    "&eth;"  : 240,
    "&yacute;" : 253,
    "&thorn;" : 254
};

var DW_EDITABLE_REGION_CONSTS = {
    EditableRegionBegin: " InstanceBeginEditable ",
    EditableRegionEnd: " InstanceEndEditable",
    EditableRegionHudCss: "dw_editableRgnHudDiv",
    EditableRgnOverlayCss: "overlay_editableRgn",
    EditableRgnHudText: "EditableRegion",
    EditableRgnName: "name"
};

//
// Constants for editable selectors
//
var DW_EDITABLE_SELECTORS_CONSTS = {
    DwDivTagName: "dw-div",
    DwElementHudClass: "dw_elementHud",
    DwTagnameClass: "dw_tagName",
    DwEditableSelectorsOverlayClassName: "overlay_editableSelectors",
    DwEditableSelectorClassName: "selectorDiv",
    DwNonEditableSelectorClassName: "selectorDivNonEditable",
    DwExpandSelectorClassName: "expandfully",
    DwSelectorContainerClassName: "selContainer",
    DwSelectorNameClassName: "selName",
    DwSelectorRemoveButtonClassName: "removeButton",
    DwSelectorRemoveButtonString: "x",
    DwAddNewSelectorButtonID: "dw_addNewSelectorButton",
    DwNewSelectorInputID: "dw_newSelectorInput",
    DwNewSelectorInputJQueryID: "#dw_newSelectorInput",
    DWEditableSelectorsContainerJQueryID: "#dw_liveedit_es_hud",
    DWMaxUntruncatedSelectorWidth: 118,
    DWBorderRadiusThreshold: 20,
    DWESHElementRowHeight: 25
};


var DWLE_IMG_CLASS = {
    Reset: "DW_Reset_All_Styles",
    Seperator: " ",
    ImgHudEntry: "dw_imgPropHud",
    ImgSelection: "dw_imgSelection",
    ImgInput: "dw_liveedit_HTMLPI_inputClass",
    ImgInputWandH: "dw_liveedit_HTMLPI_input_Width_Height",
    ImgLabel: "dw_liveedit_HTMLPI_labelClass",
    ImgLabelHeight: "dw_liveedit_HTMLPI_labelForHeight",
    ImgHudRow: "dw_liveedit_HTMLPI_row",
    ImgHudSubRow: "dw_liveedit_HTMLPI_subrow",
    ImgBtnClass: "dw_liveedit_HTMLPI_inputbtnClass",
    ImgContainer: "dw_liveedit_HTMLPIWrapper",
    ImgContainerRight: "dw_liveedit_HTMLPIWrapperRight",
    ImgContainerLeft: "dw_liveedit_HTMLPIWrapperLeft",
    ImgContainerTop: "dw_liveedit_HTMLPIWrapperTop",
    ImgContainerBottom: "dw_liveedit_HTMLPIWrapperBottom",
    NonEditable: "dw_liveedit_HTMLPINonEditable",
    ImgDropDownNone: "dw_liveedit_HTMLPI_donotShow",
    ImgDropDown: "dw_liveedit_HTMLPI_dropdownClass",
    OptionNoneFont: "dw_liveedit_HTMLPI_font",
    Unselectable: "dw_liveedit_HTMLPI_unselectable"
};
var DWLE_IMG_IDS = {
    src: "dwLeImgSrc",
    imgSrc: "dwLeImgSrcBtn",
    link: "dwLeImgLink",
    imgLink: "dwLeImgLinkBtn",
    title: "dwLeImgTitle",
    alt: "dwLeImgAlt",
    target: "dwLeImgTarget",
    width: "dwLeImgWidth",
    height: "dwLeImgHeight",
    hudEntryID: "dwLeImgHudEntry"
};
var DWLE_DIMENSIONS = {
    ImgHudWidth: 210,
    ImgHudHeight: 135,
    ElementHudDefault: 20,
    ImgHudOffSet: 13
};
var DWLE_FILEPATHS = {
    ImgHudSandWich: "/ImageHud/sandwich.PNG",
    ImgHudBrowse: "/ImageHud/folder.png",
    LiveEditPath: "/Shared/LiveEdit",
    LiveViewExtensionsListFile: "/LiveViewExtensions.xml",
    ExtensionsFolder: "/Extensions",
    DebugFilePath: "LiveEditLog.txt",
    OverLayCss: "/overlay.css",
    EditableSelctorsCss: "/EditableSelectors.css",
    EditableRegionCss: "/TemplateInstanceEditableRgn.css",
    JqueryAutoCompleteCss: "/jqueryAutoComplete.css",
    ImageHudCss: "/ImageHud/ImageHud.css"
};

var DWLE_ES_HEADLIGHTS = {
    Category: "Editable Selectors",
    HUDCreated: "ES HUD Created",
    AddSelector: "ES Added a Selector",
    HideHUDViaShortcut: "HUD hidden using keyboard shortcut",
    SWIconClicked: "Sandwich icon clicked",
    TruncatedSelector: "Selector name truncated",
    MultiLine: "HUD spanned across muliple lines",
    HUDPlacementTop: "HUD positioned at top",
    HUDPlacementBottom: "HUD positioned at bottom",
    DeleteSelector: "Selector deleted",
    RoundedCornerElement: "Element has rounded corners"
};

/* These strings should match with event strings in LiveEditUpdateUtils.cpp*/
var DW_EVENTS = {
    SelectionChanged: "dw_selection_changed",
    StylesReloaded: "liveview_styles_reloaded",
    ViewSetFocus: "liveview_setfocus",
    ViewLostFocus: "liveview_lostfocus",
    DisableExtensions: "disable_extensions",
    EnableExtensions: "enable_extensions",
    ShowAuxHud: "show_aux_hud",
    Textedit_selection_change : "textedit_selection_change",
    Textedit_make_bold: "textedit_make_bold",
    TextEdit_make_italic : "textedit_make_italic",
	ShowHelp: "show_help"
};

/* Headlight Logging Data for In-Context Text Editing */
var DW_ICE_HEADLIGHTS = {
    ELV_LVE: "ELV LVE",
    DWShortcuts: "DWShortcuts",
    OTH_ELV: "OTH ELV",
    StartEditing: "LVE StartEditing",
    SelectAll: "LVE SelectAll",
    NewTagCreatedViaEnter: "LVE NewTagCreatedViaEnter",
    Canceled: "LVE Canceled",
    TemplateEdited:	"LVE TemplateEdited",
    FGEdited: "LVE FGEdited",
    DynamicPageEdited: "LVE <File Type>Edited",
    TableEdited: "LVE TableEdited",
    CommitFailed: "LVE CommitFailed",
    InlineTagEdited_Pre: "LVE ",
    InlineTagEdited_Post: " TagEdited",
    LibEdited: "LVE LibEdited",
    ToolingToggledInOrangeHUD: "LVE ToolingToggledInOrangeHUD",
    CssElementEdited: "LVE <CSS>ElementEdited",
    RightClickDone: "LVE RightClickDone",
    Commit: "LVE Commit",
    lveFgEdited: "LVE FGEdited",
    lvePreString: "LVE ",
    lvePostStringDynamic: "Edited Dynamic",
    lvePostStringStatic: "Edited Static",
    lveTableEdited: "LVE TableEdited"
};

var DW_LIVEEDIT_DEBUGGING = false;
